define([
    'backbone',
    'Layout',
    'App',
    'modules/form/question-view',
    'modules/form/section-view',
    'modules/new-appointment-request/views/requests/phone-contact/section-view',
],
function(Backbone, Layout, app, QuestionView, SectionView, RequestDetailsPhoneContactSectionView) {
    'use strict';

    describe('Request Details Phone Contact Section View', function() {
        var view;
        var layout;

        beforeEach(function() {
            layout = new Layout();
            layout.render();
            spyOn(RequestDetailsPhoneContactSectionView.prototype, 'updateFDNS   el');

            view = new RequestDetailsPhoneContactSectionView({model: new Backbone.Model()});
            layout.showChildView('fDNS   tent', view);
        });

        afterEach(function() {
            layout.getRegion('fDNS   tent').empty();
        });

        it('initializes with all questions', function() {
            expect(view.collection.length).toEqual(4);
            expect(view.collection.at(0).id).toEqual('phoneNumber');
            expect(view.collection.at(1).id).toEqual('verifyPhoneNumber');
            expect(view.collection.at(2).id).toEqual('bestTimetoCall');
            expect(view.collection.at(3).id).toEqual('requestedPhoneCall');
        });
    });
}
);
